
import sys
from base4096 import decode

def run_hdgl_stream(stream_b4096: str):
    payload_bytes = decode(stream_b4096)
    sections = payload_bytes.split(b'\nHDGL_')
    data = {}
    for sec in sections:
        if b':' in sec:
            key, val = sec.split(b':', 1)
            data[key.decode()] = val
    # Verify fingerprint
    alphabet_bytes = data.get('ALPHABET')
    fingerprint = data.get('FINGERPRINT').decode()
    provisioner = data.get('PROVISIONER').decode()
    # Reconstruct alphabet
    delta_pairs = [int.from_bytes(alphabet_bytes[i:i+2],'big',signed=True)
                   for i in range(0,len(alphabet_bytes),2)]
    chars = []
    prev = 0
    for d in delta_pairs:
        idx = prev + d
        chars.append(chr(idx))
        prev = idx
    reconstructed_alphabet = ''.join(chars)
    # Verify fingerprint matches
    from base4096_hkdf_seal import canonical_base4096_fingerprint
    if canonical_base4096_fingerprint(reconstructed_alphabet) != fingerprint:
        raise ValueError("Fingerprint mismatch! HDGL stream corrupted.")
    # Execute provisioner
    exec(provisioner)

if __name__=="__main__":
    # The embedded Base4096 HDGL stream is appended at the end of this file
    with open(__file__,'r',encoding='utf-8') as f:
        content = f.read()
    # Find marker
    marker = '#---HDGL_STREAM_START---\n'
    hdgl_b4096 = content.split(marker)[1]
    run_hdgl_stream(hdgl_b4096.strip())

#---HDGL_STREAM_START---
4ƎՐऄѯ֥ϫ00łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG10łG1æڲԯޱճ'ӟჶϷඐၔ̢ಝ݂ોࠗ႔༲ਪǉेၻऎଞ൚ቹೈǃरॄႤૄ๘ၺขপभඵଭûਧൺႲІႲױႲâѩǃࣆǅୁǃจǉਙôখùତي५ЬऋဌၓቭષԃႥܑ࿌ݍࣽଟञ݊ஊූ़ىඑၺ௺Ģ୭ᅪ࣯ॄႥඅႲܣႲభဤቲఁၘໆ̢ඏၺഔԫ౦ܾुåටþऀÊຑၺඡಕீԘஏઝႲమၔ੍ႤໆႲయၳଟ࣬ȔൌöඁӜྐྵࡋকӭႤᅖႤቍႲӥႥǺႤຽႤ࠲Ⴅဵၥ̢ൄনඐ࡚ୁåഺâતð่ූࣂၺ෦Ģஎුජᅽູ৾ႤનႥ་ྻԫൄ݊ಝ౷ഺè୳ÿથǈৰäೇࠓႥӤ่ኅॐफ़ནၯरఛႲöມኂ૯ìଇˡ၃ཊംᆃ५ԩઌၶઓॖႥౌ๙ĢீුೂࡢಏȢಌ༮ഺíౡଞഷኊఏࡣाيࣻМඓЃႥ༊ႲॆႤ໒Ⴄ༃Ⴒ܌ႤæႥेႥǮ༜ຬႥॶႲ׳Ⴄ༠ྚଟ५Ԭࣂಖफၺ୭Ģஊܹോ܏ႥఘႥျཹᅾൠåଫأၵᅸથý੨çఓ൮ဵ࡞࣡èથåਧࠨႤǎၓ̢௩݊ෆܹਙèૌǄ౪ùకǃਾశ༯ුఠО୳äൊϔႲϏྩಕరු෧གਪùથùਂĀँǉෑϬໂቷಡӠๆࡅోä౪ñ൲úൠëࣱǄశìଜǅࣆĀ৯؉ႥॣႤۮႲԊႲӓဂ಄ંãୠϵໂࡌමǇഺîആઙၵၺநԕॱüೆۭႥ൷ႥÞဢଇ৮థႤᄬྋᆂ௸ಕ౽Ģడ౿࣠ॕဃࡢഔĢಎࣂՑʑֵੋӟᇰҠɼèҰۋ²ޒመ܀δݢᄁۯҲܬ࣬ϫ୵ɄWݳʫݓѳɰ˞क-ҏ߆ɉ´ݣےޢઃݒֵɈưګ¨ߐຢࠎµڿຜ̘בڿπ߀ંۛŤ˒௹ۋ¡ٟᄃְٜ݀ྮɧሁ݀ƫݑሁɥଡ଼ɄWɉ´ݣےޢઃݑሊگߦ˄৬